/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.cluster.verification.StorageSize;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageInfo;

public class OCFSInfo
extends StorageInfo
implements StorageConstants {
    private String m_guid;
    private String m_device;
    private FSInfo m_fsInfo;

    public OCFSInfo(String node, String path, String device, String guid) {
        this(node, path, device, guid, null);
    }

    public OCFSInfo(String node, String path, String device, String guid, FSInfo fsInfo) {
        super(path, node, 7);
        this.m_device = device;
        this.m_guid = guid;
        this.m_fsInfo = fsInfo;
    }

    public FSInfo getFSInfo() {
        return this.m_fsInfo;
    }

    public void setFSInfo(FSInfo fsInfo) {
        this.m_fsInfo = fsInfo;
    }

    @Override
    public StorageSize getFree() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("OCFS Free space on " + this.m_fsInfo.getPath() + " = " + this.m_fsInfo.getFree()));
        }
        return this.m_fsInfo.getFree();
    }

    @Override
    public StorageSize getSize() {
        return this.m_fsInfo.getSize();
    }

    protected String getDevice() {
        return this.m_device;
    }

    @Override
    public String getSignature() {
        return this.m_guid;
    }
}

